<?php
namespace Specialistaweb\Startsite\Utility;
/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */


class commonFunctions {
  /**
   * Genera un codice nel formato XAB-12345 dove
   * composto da tre lettere a caso sul 24 disponibili e 5 numeri a caso
   *
   * @param  string          Empty string (no content to process)
   * @param  array           TypoScript configuration
   */
   public function user_generateRandomNumber (string $content, array $conf): string
   {
        $length = 3;
        $chars = "ABCDEFGHIKLMNOPQRSTUVXZ";
        $string=substr(str_shuffle($chars),0,$length);

        $length = 5;
        $chars = "01234567890";
        $number = substr(str_shuffle($chars),0,$length);
	$code = $string . "-" . $number;
        return $code;
  }

  /**
   * ad uso e consumo del solo sito Cdu
   * verifica se nell'absolute path esiste il silcomposto da tre lettere a caso sul 24 disponibili e 5 numeri a caso
   *
   * @param  string          Empty string (no content to process)
   * @param  array           TypoScript configuration
   * 			     absolutePath = path assoluto della dir che deve contenere il file
   */
  public function user_checkIfYearFileExists (string $content, array $conf): string
  {
	$filename = $conf['absolutePath'] . date("Y") . ".txt";
	if(file_exists($filename)) {
		return true;
	} else {
		return false;
	}

  }

}

